/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesplus.systems.thicknesslogic;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.block.rooty.RootyBlock;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictreesplus.DynamicTreesPlus;
import com.ferreusveritas.dynamictreesplus.block.CactusBranchBlock;
import com.ferreusveritas.dynamictreesplus.systems.thicknesslogic.CactusThicknessLogic;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public final class CactusThicknessLogicKits {
    public static final CactusThicknessLogic PILLAR = new CactusThicknessLogic(DynamicTreesPlus.location("pillar")){

        @Override
        public CactusBranchBlock.CactusThickness thicknessAfterGrowthSignal(Level world, BlockPos pos, GrowSignal signal, CactusBranchBlock.CactusThickness currentThickness) {
            BlockState upState = world.m_8055_(pos.m_7494_());
            BlockState downState = world.m_8055_(pos.m_7495_());
            return upState.m_60734_() instanceof CactusBranchBlock && downState.m_60734_() instanceof CactusBranchBlock ? CactusBranchBlock.CactusThickness.TRUNK : CactusBranchBlock.CactusThickness.BRANCH;
        }

        @Override
        public CactusBranchBlock.CactusThickness thicknessForBranchPlaced(LevelAccessor world, BlockPos pos, boolean isLast) {
            BlockState downState = world.m_8055_(pos.m_7495_());
            if (TreeHelper.isRooty((BlockState)downState) || isLast) {
                return CactusBranchBlock.CactusThickness.BRANCH;
            }
            return CactusBranchBlock.CactusThickness.TRUNK;
        }
    };
    public static final CactusThicknessLogic PIPE = new CactusThicknessLogic(DynamicTreesPlus.location("pipe")){

        @Override
        public CactusBranchBlock.CactusThickness thicknessAfterGrowthSignal(Level world, BlockPos pos, GrowSignal signal, CactusBranchBlock.CactusThickness currentThickness) {
            return CactusBranchBlock.CactusThickness.BRANCH;
        }

        @Override
        public CactusBranchBlock.CactusThickness thicknessForBranchPlaced(LevelAccessor world, BlockPos pos, boolean isLast) {
            return CactusBranchBlock.CactusThickness.BRANCH;
        }
    };
    public static final CactusThicknessLogic SAGUARO = new CactusThicknessLogic(DynamicTreesPlus.location("saguaro")){

        @Override
        public CactusBranchBlock.CactusThickness thicknessAfterGrowthSignal(Level world, BlockPos pos, GrowSignal signal, CactusBranchBlock.CactusThickness currentThickness) {
            return currentThickness;
        }

        @Override
        public CactusBranchBlock.CactusThickness thicknessForBranchPlaced(LevelAccessor world, BlockPos pos, boolean isLast) {
            BlockState downState = world.m_8055_(pos.m_7495_());
            if (TreeHelper.isRooty((BlockState)downState) || downState.m_60734_() instanceof CactusBranchBlock && downState.m_61143_(CactusBranchBlock.TRUNK_TYPE) == CactusBranchBlock.CactusThickness.TRUNK && downState.m_61143_(CactusBranchBlock.ORIGIN) == Direction.DOWN) {
                return CactusBranchBlock.CactusThickness.TRUNK;
            }
            return CactusBranchBlock.CactusThickness.BRANCH;
        }
    };
    public static final CactusThicknessLogic MEGA = new CactusThicknessLogic(DynamicTreesPlus.location("mega")){

        @Override
        public CactusBranchBlock.CactusThickness thicknessAfterGrowthSignal(Level world, BlockPos pos, GrowSignal signal, CactusBranchBlock.CactusThickness currentThickness) {
            Block down = world.m_8055_(pos.m_7495_()).m_60734_();
            Block down2 = world.m_8055_(pos.m_6625_(2)).m_60734_();
            Block down3 = world.m_8055_(pos.m_6625_(3)).m_60734_();
            if (down instanceof RootyBlock || down2 instanceof RootyBlock || down3 instanceof RootyBlock) {
                return CactusBranchBlock.CactusThickness.CORE;
            }
            return CactusBranchBlock.CactusThickness.TRUNK;
        }

        @Override
        public CactusBranchBlock.CactusThickness thicknessForBranchPlaced(LevelAccessor world, BlockPos pos, boolean isLast) {
            Block down = world.m_8055_(pos.m_7495_()).m_60734_();
            Block down2 = world.m_8055_(pos.m_6625_(2)).m_60734_();
            Block down3 = world.m_8055_(pos.m_6625_(3)).m_60734_();
            if (down instanceof RootyBlock || down2 instanceof RootyBlock || down3 instanceof RootyBlock) {
                return CactusBranchBlock.CactusThickness.CORE;
            }
            if (down instanceof CactusBranchBlock) {
                return CactusBranchBlock.CactusThickness.TRUNK;
            }
            return CactusBranchBlock.CactusThickness.BRANCH;
        }
    };
}

